--------------------------------------------------------------------------------
local sysname = {
	[ "BARD" ] = "Bard",
	[ "DRUID" ] = "Druid",
	[ "MAGE" ] = "Mage",
	[ "NECROMANCER" ] = "Necromancer",
	[ "PALADIN" ] = "Paladin",
	[ "PRIEST" ] = "Priest",
	[ "PSIONIC" ] = "Psionic",
	[ "STALKER" ] = "Stalker",
	[ "WARRIOR" ] = "Warrior",
	[ "ENGINEER" ] = "Engineer"
}
local color = {
	[ "BARD" ] = { a = 255, r = 106, g = 230, b = 223 },
	[ "DRUID" ] = { a = 255, r = 255, g = 118, b = 60 },
	[ "MAGE" ] = { a = 255, r = 126, g = 159, b = 255 },
	[ "NECROMANCER" ] = { a = 255, r = 208, g = 69, b = 75 },
	[ "PALADIN" ] = { a = 255, r = 207, g = 220, b = 155 },
	[ "PRIEST" ] = { a = 255, r = 255, g = 207, b = 123 },
	[ "PSIONIC" ] = { a = 255, r = 221, g = 123, b = 245 },
	[ "STALKER" ] = { a = 255, r = 150, g = 204, b = 86 },
	[ "WARRIOR" ] = { a = 255, r = 143, g = 119, b = 75 },
	[ "ENGINEER" ] = { a = 255, r = 135, g = 163, b = 177 }
}
local platecolor = {
	[ "BARD" ] = { a = 255, r = 0, g = 255, b = 200 },
	[ "DRUID" ] = { a = 255, r = 255, g = 128, b = 0 },
	[ "MAGE" ] = { a = 255, r = 47, g = 145, b = 255 },
	[ "NECROMANCER" ] = { a = 255, r = 241, g = 43, b = 71 },
	[ "PALADIN" ] = { a = 255, r = 204, g = 255, b = 255 },
	[ "PRIEST" ] = { a = 255, r = 255, g = 227, b = 48 },
	[ "PSIONIC" ] = { a = 255, r = 255, g = 128, b = 255 },
	[ "STALKER" ] = { a = 255, r = 188, g = 255, b = 64 },
	[ "WARRIOR" ] = { a = 255, r = 165, g = 138, b = 87 },
	[ "ENGINEER" ] = { a = 255, r = 135, g = 183, b = 197 }
}
--------------------------------------------------------------------------------
for key, color in pairs( color ) do
	for id, component in pairs( color ) do
		color[ id ] = component / 255
	end
end
--------------------------------------------------------------------------------
for key, platecolor in pairs( platecolor ) do
	for id, component in pairs( platecolor ) do
		platecolor[ id ] = component / 255
	end
end
--------------------------------------------------------------------------------
local function GetClassName( sample )
	if sample then
		local sampletype = type( sample )
		
		if sampletype == "string" then
			if sysname[ sample ] then
				return sample
			else
				LogWarning( "Invalid player class sysName passed: \"", tostring( sample ), "\"" )
			end
			
		elseif sampletype == "number" then
			if unit.IsPlayer( sample ) then
				return unit.GetClass( sample ).className
			end
		end
	end
end
--------------------------------------------------------------------------------
function GetUnitClassIcon( sample )
	local classname = GetClassName( sample )
	return classname and common.GetAddonRelatedGroupTexture( "PlayerClasses", sysname[ classname ] )
end
--------------------------------------------------------------------------------
function GetUnitClassColor( sample )
	local classname = GetClassName( sample )
	return classname and color[ classname ]
end
--------------------------------------------------------------------------------
function GetUnitPlateColor( sample )
	local classname = GetClassName( sample )
	return classname and platecolor[ classname ]
end
--------------------------------------------------------------------------------